/*
 * Decompiled with CFR 0.152.
 */
public class OpenGLTextureCache {
    public OpenGLToolkit toolkit;
    public ITextureLoader textureLoader;
    public AdvancedMemoryCache history = new AdvancedMemoryCache(0xA00000, 256);

    public OpenGLTextureCache(OpenGLToolkit toolkit, ITextureLoader materials) {
        this.toolkit = toolkit;
        this.textureLoader = materials;
    }

    public OpenGLTexture2D getTexture(Material material) {
        return this.getTexture(material, material.size);
    }

    public OpenGLTexture2D getTexture(Material material, int size) {
        OpenGLTexture2D texture;
        OpenGLTexture2D cached = (OpenGLTexture2D)this.history.get(material.id);
        if (cached != null) {
            return cached;
        }
        if (!this.isReady(TextureType.DIFFUES_HDR, material, size)) {
            return null;
        }
        if (size == -1) {
            size = material.size;
        }
        if (!material.hdr || !this.toolkit.method584()) {
            int[] is = material.blending != TextureBlending.ALPHA_BLENDING || !Class132_Sub3_Sub1.method7148(material.effectId) ? this.textureLoader.loadOpaque(TextureType.DIFFUES_HDR, material.id, 0.7f, size, size, false) : this.textureLoader.loadTranslucent(TextureType.DIFFUES_HDR, material.id, 0.7f, size, size, true);
            texture = new OpenGLTexture2D(this.toolkit, 3553, size, size, material.mipmapping != 0, is, 0, 0, false);
        } else {
            float[] fs = this.textureLoader.get_diffuse_hdr_pixels(TextureType.DIFFUES_HDR, material.id, 0.7f, size, size, false);
            texture = new OpenGLTexture2D(this.toolkit, 3553, PixelFormat.aClass65_1094, DepthFormat.aClass90_1247, size, size, material.mipmapping != 0, fs, PixelFormat.aClass65_1094);
        }
        texture.setRepeat(material.repeatS, material.repeatT);
        this.history.put(texture, material.id, size * size);
        return texture;
    }

    public boolean isReady(TextureType type, Material material, int size) {
        if (size == -1) {
            size = material.size;
        }
        if (!material.hdr || !this.toolkit.method584()) {
            if (material.blending != TextureBlending.ALPHA_BLENDING || !Class132_Sub3_Sub1.method7148(material.effectId)) {
                return this.textureLoader.is_ready(type, material.id, TextureChannel.aTextureChannel_7923, 0.7f, size, size, false);
            }
            return this.textureLoader.is_ready(type, material.id, TextureChannel.aTextureChannel_7924, 0.7f, size, size, true);
        }
        return this.textureLoader.is_ready(type, material.id, TextureChannel.aTextureChannel_7922, 0.7f, size, size, false);
    }

    public void processAgeCycle() {
        this.history.processAgeCycle(5);
    }

    public void clear() {
        this.history.clear();
    }
}

